function [sys,x0,str,ts] = CloseLoopControlDSPFor3level5phaseOptimizedSwitchSequence(t,x,u,flag)
% This program is based on Symmetrical OFV swapping technique
% The following code can be functioned as follows:
% A: Open loop operation
% B: Close loop operaion for SVM DTC
% C: Hyteresis band method to balance the neutral point voltage 
% D: Use PI to balance the neutral point voltage
% the code has been tested in 5/08/2008 by liliang Gao

switch flag,

  %%%%%%%%%%%%%%%%%%
  % Initialization %
  %%%%%%%%%%%%%%%%%%
  case 0,
    [sys,x0,str,ts]=mdlInitializeSizes;

  %%%%%%%%%%%%%%%
  % Derivatives %
  %%%%%%%%%%%%%%%
  case 1,
    sys=mdlDerivatives(t,x,u);

  %%%%%%%%%%
  % Update %
  %%%%%%%%%%
  case 2,
    sys=mdlUpdate(t,x,u);

  %%%%%%%%%%%
  % Outputs %
  %%%%%%%%%%%
  case 3,
    sys=mdlOutputs(t,x,u);

  %%%%%%%%%%%%%%%%%%%%%%%
  % GetTimeOfNextVarHit %
  %%%%%%%%%%%%%%%%%%%%%%%
  case 4,
    sys=mdlGetTimeOfNextVarHit(t,x,u);

  %%%%%%%%%%%%%
  % Terminate %
  %%%%%%%%%%%%%
  case 9,
    sys=mdlTerminate(t,x,u);

  %%%%%%%%%%%%%%%%%%%%
  % Unexpected flags %
  %%%%%%%%%%%%%%%%%%%%
  otherwise
    error(['Unhandled flag = ',num2str(flag)]);

end

% end sfuntmpl

%
%=============================================================================
% mdlInitializeSizes
% Return the sizes, initial conditions, and sample times for the S-function.
%=============================================================================
%
function [sys,x0,str,ts]=mdlInitializeSizes

%
% call simsizes for a sizes structure, fill it in and convert it to a
% sizes array.
%
% Note that in this example, the values are hard coded.  This is not a
% recommended practice as the characteristics of the block are typically
% defined by the S-function parameters.
%
sizes = simsizes;

sizes.NumContStates  = 0;
sizes.NumDiscStates  = 26;
sizes.NumOutputs     = 21;
sizes.NumInputs      = 18;
sizes.DirFeedthrough = 1;
sizes.NumSampleTimes = 1;   % at least one sample time is needed


sys = simsizes(sizes);

%
% initialize the initial conditions
%
x0=[0;0;0;0;0;0;0;0;0.5;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0];
%
% str is always an empty matrix
%
str = [];

%
% initialize the array of sample times
%
ts=[200e-6 0];
% end 0mdlInitializeSizes

%
%=============================================================================
% mdlDerivatives
% Return the derivatives for the continuous states.
%=============================================================================
%
function sys=mdlDerivatives(t,x,u)

sys = [];

% end mdlDerivatives

%
%=============================================================================
% mdlUpdate
% Handle discrete state updates, sample time hits, and major time step
% requirements.
%=============================================================================
%
function sys=mdlUpdate(t,x,u)

Kit=0.15; %0.10  % was 0.15
Kpt=1;   %1      % was 1.2         
Kif=2; % 0.6   % was 1.2
Kpf=15;   % 10     % was 10

Kispd=0.06;          
Kpspd=2;    
Kcorspd=0.03;

Ki= 0.8; % 0.08;%0.000008 %0.000008 % 0.00008 % 0.00008  %0.000008 %0.000008      % 0.00008 for the open loop
Kp= 2;    %1;   %0.01  %0.004 % 0.04 %0.02  %0.01           % 0.01 for the open loop

Rs=0.60;
Rr=0.48;
Lls=2.5e-3;
Llr=2.5e-3;
Lm=151e-3;
Ls=Lm+Lls;
Lr=Lm+Llr;
Q=1-Lm^2/(Ls*Lr);       % Stator leakage coefficient
underlap=1.5e-6;
DeadBand=1.5e-6;
%--------------------------------------------------------------------
a=2*pi/5;         Ts=200e-6;
sina=sin(a);      sin2a=sin(2*a);
sin3a=sin(3*a);   sin4a=sin(4*a);
cosa=cos(a);      cos2a=cos(2*a);
cos3a=cos(3*a);   cos4a=cos(4*a);

SpeedErrStmax=10.65;
SpeedErrStmin=-10.65;
Torquemax=10.65;
Torquemin=-10.65;

%------------------- input signal-------------------------------------
   
    Valpha1=u(1);          
    Vbeta1=u(2);
    
%     Vd1=u(1);          
%     Vq1=u(2);
    
    Ia=u(3);
    Ib=u(4);
    Ic=u(5);
    Id=u(6);
    Ie=u(7);
    FluxRef=u(8);
    SpeedRef=u(9);
    Rposition=u(10); 
    RotorSpeed=u(11);
    VoltageDiff=u(12);
   % DCLinkVol=u(13);
    Lamda_d1ss=u(14);
    Lamda_q1ss=u(15);
    Te=u(16);
    NeutralPointCurrent=u(17);
    NeutralControl=u(18);
    
    if u(13)==0 Vdc=1e-6; else Vdc=u(13); end
   
 %---------------------------------------Limit if the max and min Flux, Torque and Vd----------   
    FluxErrStmax= 0.5*Vdc;   % 0.665*Vdc is the vector length for m=0.8
    FluxErrStmin=-0.5*Vdc;
    TorqueErrStmax= 0.5*Vdc;
    TorqueErrStmin=-0.5*Vdc;
    Vdsemax= 0.5*Vdc;
    Vdsemin=-0.5*Vdc;
    % PF=x(26);
%--------------------------------------------------------------------    
    Idss=(0.4)*(Ia+cosa*Ib+cos2a*Ic+cos3a*Id+cos4a*Ie);
    Iqss=(0.4)*(   sina*Ib+sin2a*Ic+sin3a*Id+sin4a*Ie);
%     TempValue=sqrt(Idss^2+Iqss^2);
%     if (TempValue==0)
%         TempValue=0.00000001;
%     end
%     PF=cos(Idss/TempValue);
%--------------------------------------------------------------------------
     StatorFlux_ds=x(1);       % Calculate stator flux mag and ang
     StatorFlux_qs=x(2);
     FluxErrSt=x(3);
     TorqueErrSt=x(4);
     SpeedErrSt=x(5);           % Speed regulation
     SpeedCalCnt=x(6);
     TorqueRef=x(7);
     VoltageErrStat=x(8);
     DutyRatio=x(9);
    
    
    if (SpeedCalCnt==0) 
    SpeedErr=SpeedRef-RotorSpeed;
    Upispd=SpeedErrSt+Kpspd*SpeedErr;
    TorqueRef=Upispd;          % Integration Correction
    if (Upispd>Torquemax) TorqueRef=Torquemax; end
    if (Upispd<Torquemin) TorqueRef=Torquemin; end
    
     %SpeedErrSt=SpeedErrSt+Kispd*SpeedErr;
     SpeedErrSt=SpeedErrSt+Kispd*SpeedErr+Kcorspd*(TorqueRef-Upispd);
    end
    
    SpeedCalCnt=SpeedCalCnt+1;
    if (SpeedCalCnt>=60)
        SpeedCalCnt=0;
    end
%--------------------------------------------------------------------------  
   
  if x(10)==0 RotorFluxMag=1e-6;else RotorFluxMag=x(10);end
    RFluxSlipAng=x(11);
    RotorFluxAng=x(12);%Flux update
    RotorFluxAng=rem((Rposition+RFluxSlipAng), 2*pi);
    
    Idse=Idss*cos(RotorFluxAng)+Iqss*sin(RotorFluxAng);
    Iqse=-Idss*sin(RotorFluxAng)+Iqss*cos(RotorFluxAng);
    
    Tr=Lr/Rr;
    RotorFluxMag=RotorFluxMag+(Lm*Idse-RotorFluxMag)*Ts/Tr;
    RFluxSlipAng=rem((RFluxSlipAng+Lm/RotorFluxMag*Iqse*Ts/Tr), 2*pi);
   
     Idre=(RotorFluxMag-Lm*Idse)/Lr;
     Iqre=-Lm*Iqse/Lr;
%     
     Idrs=Idre*cos(RotorFluxAng)-Iqre*sin(RotorFluxAng);
     Iqrs=Idre*sin(RotorFluxAng)+Iqre*cos(RotorFluxAng);
%    
%      RotorFluxMag_ds=RotorFluxMag*cos( RotorFluxAng);
%      RotorFluxMag_qs=RotorFluxMag*sin( RotorFluxAng);
%      
%      Idrs=(RotorFluxMag_ds-Lm*Idss)/Lr;
%      Iqrs=(RotorFluxMag_qs-Lm*Iqss)/Lr;
     StatorFlux_ds=Ls*Idss+Lm*Idrs;
     StatorFlux_qs=Ls*Iqss+Lm*Iqrs;
    
     %StatorFlux_ds= Lamda_d1ss;
     %StatorFlux_qs=Lamda_q1ss;
 
             
     StatorFluxMag=sqrt(StatorFlux_ds^2+StatorFlux_qs^2);
     if(StatorFluxMag==0)
        StatorFluxMag=1e-6;
     end
     StatorFluxAng=x(13);
     StatorFluxAng=acos(StatorFlux_ds/StatorFluxMag);
     if StatorFlux_qs<0
        StatorFluxAng=2*pi-StatorFluxAng;
     end
%--------------------------------------------------------------------------
    %Torque1=x(14);
    Torque1=2.5*Lm*RotorFluxMag*Iqse/Lr;
    %Torque1=Lm*(Iqse*Idre - Idse*Iqre)*2.5;
    
  
    %Torque1= 2.5*Lm*( Lamda_d1ss*Iqss - Lamda_q1ss*Idss);
%--------------------------------------------------------------------------
    TorqueErr=TorqueRef-Torque1;% Torque and flux regulation
    FluxErr=FluxRef-StatorFluxMag;
       
    FluxErrSt=FluxErrSt+Kif*FluxErr;   
    if (FluxErrSt>FluxErrStmax)	       
    FluxErrSt=FluxErrStmax;
    end
    if (FluxErrSt<FluxErrStmin)
    FluxErrSt=FluxErrStmin;
    end
    
    TorqueErrSt=TorqueErrSt+Kit*TorqueErr;
    if (TorqueErrSt>TorqueErrStmax)
    TorqueErrSt=TorqueErrStmax;
    end
    if (TorqueErrSt<TorqueErrStmin)
    TorqueErrSt=TorqueErrStmin;
    end
    
    Vdse=FluxErrSt+Kpf*FluxErr;
    Vqse=TorqueErrSt+Kpt*TorqueErr;
    
%--------------------------------------------------------------------------     
    if Vdse>Vdsemax    Vdse=Vdsemax;    end
    if Vdse<Vdsemin    Vdse=Vdsemin;    end
    
    Vqsemax=sqrt(Vdsemax*Vdsemax-Vdse*Vdse);      
    Vqsemin=-Vqsemax;
    
    if Vqse>Vqsemax    Vqse=Vqsemax;    end
    if Vqse<Vqsemin    Vqse=Vqsemin;    end
%--------------------------------------------------------------------------
    Vdss=Vdse*cos(StatorFluxAng)-Vqse*sin(StatorFluxAng);
    Vqss=Vdse*sin(StatorFluxAng)+Vqse*cos(StatorFluxAng);
%--------------------------------------------------------------------------
    VectorLength=x(26);
    VectorLength=sqrt(Vdss^2+Vqss^2);    % Space vector modulation
    VectorAngle=acos(Vdss/VectorLength);
    if Vqss<0
       VectorAngle=2*pi-VectorAngle;
    end
%-------------------------------PI Capacitor Voltage Balance--------------
if(NeutralControl==1)
VoltageRef=0;
VoltageErr=(VoltageRef+VoltageDiff);
VoltageErrStat=VoltageErrStat+VoltageErr*Ki;
DutyRatio=VoltageErrStat+Kp*VoltageErr;

if (DutyRatio>=0.5)    %0.5
    DutyRatio=0.5;
end
if (DutyRatio<0)
    DutyRatio=0;
end
else
 DutyRatio=0.5;
end

%------------------------------hysteresis band balance algorithm--------------
%  if (VoltageDiff>=1.5)   %1.5
%      UpperBand=1;
%  end
%  if(0<=VoltageDiff<1.5)
%      UpperBand=0;
%  end
%  if(0>VoltageDiff>-1.5)
%      LowerBand=0;
%  end
%   if(VoltageDiff<=-1.5)
%      LowerBand=1;
%   end
% 
%  if (UpperBand==1&&LowerBand==0)
%      DutyRatio=DutyRatio+0.00000004; % 0.01  %0.001
%      if (DutyRatio>=0.5)
%         DutyRatio=0.5;
%      end
%  end
%  
%   if (UpperBand==0&&LowerBand==1)
%      DutyRatio=DutyRatio-0.00000004;
%      if (DutyRatio<=0)
%         DutyRatio=0;
%      end
%   end
%  
%    if (UpperBand==0&&LowerBand==0)
%      if(DutyRatio>=0.5)
%           DutyRatio=0.5;
%      else
%          DutyRatio=DutyRatio+0.00000004; 
%          if (DutyRatio>=0.5)
%            DutyRatio=0.5;
%          end
%      end
%   end
%-----------------------------open loop algorithm ------------------

%     theta1=rem(2*pi*50*t,2*pi)
%     Valpha1=Vd1*cos(theta1)-Vq1*sin(theta1);
%     Vbeta1=Vd1*sin(theta1)+Vq1*cos(theta1);
%     
%     VectorLength=sqrt(Valpha1^2+Vbeta1^2);
%     if(VectorLength==0)
%         VectorLength=0.000001;
%     end
%     
%     VectorAngle=acos(Valpha1/VectorLength);
%    
%     
%      if Vbeta1<0
%        VectorAngle=2*pi-VectorAngle;
%     end
    
    
%------------------ stationary reference frame---------------------

%     VectorLength=sqrt(Valpha1^2+Vbeta1^2);
%     if(VectorLength==0)
%         VectorLength=0.000001;
%     end
%     
%     VectorAngle=acos(Valpha1/VectorLength);
%    
%     
%      if Vbeta1<0
%        VectorAngle=2*pi-VectorAngle;
%     end

%--------------------------------------------------------------------
    if VectorAngle>(9*pi/5)
       SectorNum=10;
    elseif VectorAngle>(8*pi/5)
       SectorNum=9;
    elseif VectorAngle>(7*pi/5)
       SectorNum=8;
    elseif VectorAngle>(6*pi/5)
       SectorNum=7;
    elseif VectorAngle>(pi)
       SectorNum=6;
    elseif VectorAngle>(4*pi/5)
       SectorNum=5;
    elseif VectorAngle>(3*pi/5)
       SectorNum=4;
    elseif VectorAngle>(2*pi/5)
       SectorNum=3;
    elseif VectorAngle>(pi/5)
       SectorNum=2;
    else
       SectorNum=1;
    end

%--define voltage vector factor to calculate the applying time-------------
delta=2*pi/5;
K=(1+sqrt(5))/2;
LengthA=Vdc*(1+K^2)/(5*(1+K)); % Length A and B and C is the 0 degree direction length of the sector one 
LengthB=LengthA*(1+1/K);           
LengthC=LengthA*(1+1/K+1/K^2);

ProjectionLengthK1=LengthA*cos(pi/10);
ProjectionLengthK2=LengthB*cos(pi/10);
ProjectionLengthK3=LengthC*cos(pi/10);

ProjectionLengthL1=LengthA*cos(pi/10);
ProjectionLengthL2=LengthB*cos(pi/10);

ProjectionLengthM1=LengthA*sin(pi/5);
ProjectionLengthM2=LengthB*sin(pi/5);

ProjectionLengthN1=LengthA*cos(pi/10);
ProjectionLengthN2=LengthB*cos(pi/10);

ProjectionLengthP1=LengthA*sin(pi/5);
ProjectionLengthP2=LengthB*sin(pi/5);


   Factor_K1=2*(5+sqrt(5))/4;
   Factor_K2=2*sqrt(10-2*sqrt(5))/4;
   Factor_K3=2*(5-sqrt(5))/4;
   Factor_K4=2*sqrt(10+2*sqrt(5))/4;
   Factor_K5=2*sqrt(5)/2;
   Factor_K6=2*(sqrt(10+2*sqrt(5))+sqrt(10-2*sqrt(5)))/4;
   Factor_K7=2*(sqrt(10+2*sqrt(5))-sqrt(10-2*sqrt(5)))/4;   
   Theta=VectorAngle-pi/5*(SectorNum-1);
   VolVectorDss=VectorLength/Vdc*cos(Theta)*Ts;
   VolVectorQss=VectorLength/Vdc*sin(Theta)*Ts;
                  
%---------------------Region Recognization and applying time calculation--------

    Vref_M=VectorLength*cos(pi/2-Theta);
    Vref_L=VectorLength*cos(3*pi/10-Theta);
    Vref_K=VectorLength*cos(Theta-pi/10);
    Vref_N=VectorLength*cos(Theta+pi/10);
    Vref_P=VectorLength*cos(Theta+3*pi/10);
                   
                   
    if (Vref_K<ProjectionLengthK1)
     
     T0=2*Factor_K4*VolVectorQss;
     T1=Factor_K5*VolVectorDss-Factor_K6*VolVectorQss;
     T2=2*Factor_K2*VolVectorQss;
     T3=Ts-Factor_K1*VolVectorDss-Factor_K2*VolVectorQss;
     T4=Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     Region=1;
    
    end
                   
     if ((Vref_K>=ProjectionLengthK1)&&(Vref_N<ProjectionLengthN1)&&( Vref_L<ProjectionLengthL1))

     T0=2*Factor_K4*VolVectorQss;
     T1=Factor_K5*VolVectorDss-Factor_K6*VolVectorQss;
     T2=Ts-Factor_K1*VolVectorDss+Factor_K2*VolVectorQss;
     T3=Factor_K1*VolVectorDss+Factor_K2*VolVectorQss-Ts;
     T4=Ts-Factor_K5*VolVectorDss-Factor_K6*VolVectorQss;
     Region=2;
     end
                   
     if ((Vref_K>=ProjectionLengthK1)&&(Vref_N>=ProjectionLengthN1)&&( Vref_L<ProjectionLengthL1))    
     T0=2*Factor_K4*VolVectorQss;
     T1=Ts-Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T2=Factor_K1*VolVectorDss-Factor_K2*VolVectorQss-Ts;
     T3=2*Factor_K2*VolVectorQss;
     T4=Ts-Factor_K5*VolVectorDss-Factor_K6*VolVectorQss;
     Region=3;
     end
                   
     if ((Vref_K>=ProjectionLengthK1)&&(Vref_K<ProjectionLengthK2)&&(Vref_N<ProjectionLengthN1)&&( Vref_L>=ProjectionLengthL1))
     T0=Ts-Factor_K5*VolVectorDss+Factor_K7*VolVectorQss;
     T1=Factor_K5*VolVectorDss-Factor_K6*VolVectorQss;
     T2=Ts-Factor_K1*VolVectorDss+Factor_K2*VolVectorQss;
     T3=Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T4=Factor_K5*VolVectorDss+Factor_K6*VolVectorQss-Ts;
     Region=4;
     end

     if ((Vref_K>=ProjectionLengthK1)&&(Vref_K<ProjectionLengthK2)&&(Vref_N>=ProjectionLengthN1)&&( Vref_L>=ProjectionLengthL1))
     T0=Ts-Factor_K5*VolVectorDss+Factor_K7*VolVectorQss;
     T1=Ts-Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T2=Factor_K1*VolVectorDss-Factor_K2*VolVectorQss-Ts;
     T3=Ts-Factor_K5*VolVectorDss-Factor_K7*VolVectorQss;
     T4=Factor_K5*VolVectorDss+Factor_K6*VolVectorQss-Ts;
     Region=5;
     end
     if ((Vref_P>=ProjectionLengthP2)&&( Vref_K<= ProjectionLengthK3))
     T0=2*Ts-Factor_K1*VolVectorDss-Factor_K2*VolVectorQss;
     T1=Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T2=2*Factor_K4*VolVectorQss;
     T3=Factor_K5*VolVectorDss-Factor_K6*VolVectorQss-Ts;
     T4=2*Factor_K2*VolVectorQss;
     Region=6;
     end
     if ((Vref_P>=ProjectionLengthP1)&&(Vref_P<ProjectionLengthP2)&&(Vref_N>ProjectionLengthN2)&&( Vref_K<= ProjectionLengthK3))
     T0=2*Ts-Factor_K1*VolVectorDss-Factor_K2*VolVectorQss;
     T1=Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T2=Factor_K5*VolVectorDss+Factor_K7*VolVectorQss-Ts;
     T3=Ts-Factor_K5*VolVectorDss+Factor_K6*VolVectorQss;
     T4=Factor_K5*VolVectorDss-Factor_K7*VolVectorQss-Ts;
     Region=7;
     end
     if ((Vref_K>=ProjectionLengthK2)&&(Vref_K<ProjectionLengthK3)&&(Vref_N<ProjectionLengthN2)&&( Vref_L<ProjectionLengthL2))
     T0=Ts-Factor_K5*VolVectorDss+Factor_K7*VolVectorQss;
     T1=Ts-Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T2=Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T3=Factor_K5*VolVectorDss+Factor_K7*VolVectorQss-Ts;
     T4=2*Factor_K2*VolVectorQss;
     Region=8;
     end
     if ((Vref_K>=ProjectionLengthK2)&&(Vref_K<ProjectionLengthK3)&&(Vref_M<ProjectionLengthM2)&&( Vref_L>=ProjectionLengthL2)&&(Vref_M>=ProjectionLengthM1))
     T0=2*Ts-Factor_K1*VolVectorDss-Factor_K2*VolVectorQss;
     T1=Factor_K3*VolVectorDss+Factor_K4*VolVectorQss-Ts;
     T2=Ts-2*Factor_K4*VolVectorQss;
     T3=Factor_K5*VolVectorDss+Factor_K7*VolVectorQss-Ts;
     T4=2*Factor_K2*VolVectorQss;
     Region=9;
     end

     if ((Vref_K>=ProjectionLengthK2)&&(Vref_K<ProjectionLengthK3)&&(Vref_M>=ProjectionLengthM2))
     T0=2*Ts-Factor_K1*VolVectorDss-Factor_K2*VolVectorQss;
     T1=Factor_K3*VolVectorDss-Factor_K4*VolVectorQss;
     T2=2*Factor_K4*VolVectorQss-Ts;
     T3=Factor_K5*VolVectorDss-Factor_K6*VolVectorQss;
     T4=2*Factor_K2*VolVectorQss;
     Region=10;
     end 
%--------------------------------------------------------------------
% calculate pulse width and swithing points for each phase
    if mod(SectorNum, 2)==1
       if(Region==1)
%        pulsewidth_a=T1+T2+T3+T4+T0/2;
%        pulsewidth_b=T2+T3+T4+T0/2;
%        pulsewidth_c=T4+T0/2;
%        pulsewidth_d=T0/2;
%        pulsewidth_e=T3+T4+T0/2;
%        SwitchState_a=0;
%        SwitchState_b=0;
%        SwitchState_c=0;
%        SwitchState_d=0;
%        SwitchState_e=0;
       if(T0<T1)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       pulsewidth_a=T0+T4+T1_DutyRatio;
       pulsewidth_b=T0+T1_DutyRatio;
       pulsewidth_c=T0+T2+T3+T4+T1_DutyRatio;
       pulsewidth_d=T0+T3+T4+T1_DutyRatio;
       pulsewidth_e=T1_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       else
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end 
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T4+T0_DutyRatio;
       pulsewidth_b=T0_DutyRatio;
       pulsewidth_c=T2+T3+T4+T0_DutyRatio;
       pulsewidth_d=T3+T4+T0_DutyRatio;
       pulsewidth_e=T1+T2+T3+T4+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=0;
       end
       end
       
       if(Region==2)
       if(T0>T1)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end 
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T3+T4+T0_DutyRatio;
       pulsewidth_b=T0_DutyRatio;
       pulsewidth_c=T2+T3+T4+T0_DutyRatio;
       pulsewidth_d=T4+T0_DutyRatio;
       pulsewidth_e=T1+T2+T3+T4+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=0;
       else
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       pulsewidth_a=T3+T4+T0+T1_DutyRatio;
       pulsewidth_b=T0+T1_DutyRatio;
       pulsewidth_c=T2+T3+T4+T0+T1_DutyRatio;
       pulsewidth_d=T4+T0+T1_DutyRatio;
       pulsewidth_e=T1_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       end

       if(Region==3)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       pulsewidth_a=T2+T3+T4+T0+T1_DutyRatio;
       pulsewidth_b=T0+T1_DutyRatio;
       pulsewidth_c=T3+T4+T0+T1_DutyRatio;
       pulsewidth_d= T4+T0+T1_DutyRatio;
       pulsewidth_e=T1_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       
       if(Region==4)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T3+T4+ T0_DutyRatio;
       pulsewidth_b=T4+ T0_DutyRatio;
       pulsewidth_c=T2+T3+T4+T0_DutyRatio;
       pulsewidth_d= T0_DutyRatio;
       pulsewidth_e=T1+T2+T3+T4+ T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=0;
       end
       
       if(Region==5)
       if(T0>T1)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T2+T3+T4+T0_DutyRatio;
       pulsewidth_b=T4+T0_DutyRatio;
       pulsewidth_c=T3+T4+T0_DutyRatio;
       pulsewidth_d=T0_DutyRatio;
       pulsewidth_e=T1+T2+T3+T4+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=0;
       else
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       pulsewidth_a=T2+T3+T4+T0+T1_DutyRatio;
       pulsewidth_b=T4+T0+T1_DutyRatio;
       pulsewidth_c=T3+T4+T0+T1_DutyRatio;
       pulsewidth_d=T0+T1_DutyRatio;
       pulsewidth_e=T1_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       end
       
       if(Region==6)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T1+T2+T3+T4+T0_DutyRatio;
       pulsewidth_b=T2+T3+T4+T0_DutyRatio;
       pulsewidth_c=T4+T0_DutyRatio;
       pulsewidth_d=T0_DutyRatio;
       pulsewidth_e=T3+T4+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       
       if(Region==7)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T1+T2+T3+T4+T0_DutyRatio;
       pulsewidth_b=T2+T3+T4+T0_DutyRatio;
       pulsewidth_c=T3+T4+T0_DutyRatio;
       pulsewidth_d=T0_DutyRatio;
       pulsewidth_e=T4+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       
       if(Region==8)
       if(T0>T1)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T2+T3+T4+T0_DutyRatio;
       pulsewidth_b=T3+T4+T0_DutyRatio;
       pulsewidth_c=T4+T0_DutyRatio;
       pulsewidth_d=T0_DutyRatio;
       pulsewidth_e=T1+T2+T3+T4+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=0;
       else
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       pulsewidth_a=T2+T3+T4+T0+T1_DutyRatio;
       pulsewidth_b=T3+T4+T0+T1_DutyRatio;
       pulsewidth_c=T4+T0+T1_DutyRatio;
       pulsewidth_d=T0+T1_DutyRatio;
       pulsewidth_e=T1_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       end
       
       if(Region==9)
       if(NeutralControl==1)
        if ((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
        end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T1+T2+T3+T4+T0_DutyRatio;
       pulsewidth_b=T3+T4+T0_DutyRatio;
       pulsewidth_c=T4+T0_DutyRatio;
       pulsewidth_d=T0_DutyRatio;
       pulsewidth_e=T2+T3+T4+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=0;
       end
       
       if(Region==10)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T1+T2+T3+T4+T0_DutyRatio;
       pulsewidth_b=T2+T3+T4+T0_DutyRatio;
       pulsewidth_c=T4+T0_DutyRatio;
       pulsewidth_d=T0_DutyRatio;
       pulsewidth_e=T3+T4+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=0;
       end
    else
       if(Region==1)
%        pulsewidth_a=T1+T2+T3+T4+T0/2;
%        pulsewidth_b=T2+T1+T0/2;
%        pulsewidth_c=T0/2;
%        pulsewidth_d=T1+T0/2;
%        pulsewidth_e=T1+T2+T3+T0/2;
%        SwitchState_a=0;
%        SwitchState_b=0;
%        SwitchState_c=0;
%        SwitchState_d=0;
%        SwitchState_e=0;
       if(T0<T1)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       pulsewidth_a=T2+T1_DutyRatio;
       pulsewidth_b=T4+T3+T2+T0+T1_DutyRatio;
       pulsewidth_c=T2+T3+T1_DutyRatio;
       pulsewidth_d=T2+T3+T4+T1_DutyRatio;
       pulsewidth_e=T1_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=0;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       else
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T2+T1+T0_DutyRatio;
       pulsewidth_b=T0_DutyRatio;
       pulsewidth_c=T2+T3+T1+T0_DutyRatio;
       pulsewidth_d=T2+T3+T4+T1+T0_DutyRatio;
       pulsewidth_e=T1+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       end
       
       if(Region==2)
       if(T0<T1)
         if(NeutralControl==1)
           if ((Ia>=0)&&(Ie>=0))
             T1_DutyRatio=(DutyRatio)*T1;
           else
             T1_DutyRatio=(1-DutyRatio)*T1;
          end
         else
          T1_DutyRatio=(1-DutyRatio)*T1;
        end
       pulsewidth_a=T2+T3+ T1_DutyRatio;
       pulsewidth_b=T0+T2+T3+T4+T1_DutyRatio;
       pulsewidth_c= T2+T1_DutyRatio;
       pulsewidth_d=T2+T3+T4+T1_DutyRatio;
       pulsewidth_e=T1_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=0;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       else
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T2+T3+ T1+T0_DutyRatio;
       pulsewidth_b=T0_DutyRatio;
       pulsewidth_c= T2+T1+T0_DutyRatio;
       pulsewidth_d=T2+T3+T4+T1+T0_DutyRatio;
       pulsewidth_e=T1+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       end

       if(Region==3)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
%        pulsewidth_a=T3+T2+T1+T0_DutyRatio;
%        pulsewidth_b=T0_DutyRatio;
%        pulsewidth_c=T1+T0_DutyRatio;
%        pulsewidth_d=T3+T2+T4+T1+T0_DutyRatio;
%        pulsewidth_e=T2+T1+T0_DutyRatio;
%        SwitchState_a=1;
%        SwitchState_b=1;
%        SwitchState_c=0;
%        SwitchState_d=0;
%        SwitchState_e=1;
       pulsewidth_a=T3+T2+T1_DutyRatio;
       pulsewidth_b=T0+T4+T3+T2+T1_DutyRatio;
       pulsewidth_c=T1_DutyRatio;
       pulsewidth_d=T3+T2+T4+T1_DutyRatio;
       pulsewidth_e=T2+T1_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=0;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       
       if(Region==4)
        if(NeutralControl==1)
        if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
        T0_DutyRatio=(DutyRatio)*T0;
        else
        T0_DutyRatio=(1-DutyRatio)*T0;
        end
        else
        T0_DutyRatio=(1-DutyRatio)*T0; 
        end
%        pulsewidth_a=T4+T3+T2+T1_DutyRatio;
%        pulsewidth_b=T0+T4+T3+T2+T1_DutyRatio;
%        pulsewidth_c=T2+T1_DutyRatio;
%        pulsewidth_d=T2+T3+T1_DutyRatio;
%        pulsewidth_e=T1_DutyRatio;
%        SwitchState_a=1;
%        SwitchState_b=0;
%        SwitchState_c=0;
%        SwitchState_d=0;
%        SwitchState_e=1;
       
       pulsewidth_a=T4+T3+T2+T1+T0_DutyRatio;
       pulsewidth_b=T0_DutyRatio;
       pulsewidth_c=T2+T1+T0_DutyRatio;
       pulsewidth_d=T2+T3+T1+T0_DutyRatio;
       pulsewidth_e=T1+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       
       if(Region==5)
       if(T1>T0)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       pulsewidth_a=T2+T3+T4+T1_DutyRatio;
       pulsewidth_b=T0+T2+T3+T4+T1_DutyRatio;
       pulsewidth_c=T1_DutyRatio;
       pulsewidth_d=T3+T2+T1_DutyRatio;
       pulsewidth_e=T2+T1_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=0;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       else
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0; 
       end
       pulsewidth_a=T2+T3+T4+T1+T0_DutyRatio;
       pulsewidth_b=T0_DutyRatio;
       pulsewidth_c=T1+T0_DutyRatio;
       pulsewidth_d=T3+T2+T1+T0_DutyRatio;
       pulsewidth_e=T2+T1+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       end
       
       if(Region==6)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T1+T2+T3+T4+T0_DutyRatio;
       pulsewidth_b=T1+T2+T0_DutyRatio;
       pulsewidth_c=T0_DutyRatio;
       pulsewidth_d=T1+T0_DutyRatio;
       pulsewidth_e=T1+T2+T3+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=0;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       
       if(Region==7)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T1+T2+T3+T4+T0_DutyRatio;
       pulsewidth_b=T1+T2+T3+T0_DutyRatio;
       pulsewidth_c=T0_DutyRatio;
       pulsewidth_d=T1+T0_DutyRatio;
       pulsewidth_e=T1+T2+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=0;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       
       if(Region==8)
           
       if(T1>T0)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ie>=0))
       T1_DutyRatio=(DutyRatio)*T1;
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       else
       T1_DutyRatio=(1-DutyRatio)*T1;
       end
       pulsewidth_a=T4+T2+T3+T1_DutyRatio;
       pulsewidth_b=T0+T2+T3+T4+T1_DutyRatio;
       pulsewidth_c=T1_DutyRatio;
       pulsewidth_d=T2+T1_DutyRatio;
       pulsewidth_e=T2+T3+T1_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=0;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       else
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T4+T2+T3+T1+T0_DutyRatio;
       pulsewidth_b=T0_DutyRatio;
       pulsewidth_c=T1+T0_DutyRatio;
       pulsewidth_d=T2+T1+T0_DutyRatio;
       pulsewidth_e=T2+T3+T1+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       end
       
       if(Region==9)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       pulsewidth_a=T1+T2+T3+T4+T0_DutyRatio;
       pulsewidth_b=T1+T0_DutyRatio;
       pulsewidth_c=T0_DutyRatio;
       pulsewidth_d=T1+T2+T0_DutyRatio;
       pulsewidth_e=T1+T2+T3+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
       
       if(Region==10)
       if(NeutralControl==1)
       if ((Ia>=0)&&(Ib>=0)&&(Ie>=0))
       T0_DutyRatio=(DutyRatio)*T0;
       else
       T0_DutyRatio=(1-DutyRatio)*T0;
       end
       else
       T0_DutyRatio=(1-DutyRatio)*T0; 
       end
       pulsewidth_a=T1+T2+T3+T4+T0_DutyRatio;
       pulsewidth_b=T1+T2+T0_DutyRatio;
       pulsewidth_c=T0_DutyRatio;
       pulsewidth_d=T1+T0_DutyRatio;
       pulsewidth_e=T1+T2+T3+T0_DutyRatio;
       SwitchState_a=1;
       SwitchState_b=1;
       SwitchState_c=0;
       SwitchState_d=0;
       SwitchState_e=1;
       end
    end
    
    
       if pulsewidth_a>=Ts-2*underlap;
          pulsewidth_a=Ts-2*underlap; 
       end
        if pulsewidth_a<=2*underlap;
          pulsewidth_a=2*underlap; 
        end
       
       if pulsewidth_b>=Ts-2*underlap;
          pulsewidth_b=Ts-2*underlap; 
       end
        if pulsewidth_b<=2*underlap;
          pulsewidth_b=2*underlap; 
        end
        
        if pulsewidth_c>=Ts-2*underlap;
          pulsewidth_c=Ts-2*underlap; 
       end
        if pulsewidth_c<=2*underlap;
          pulsewidth_c=2*underlap; 
        end
        
        if pulsewidth_d>=Ts-2*underlap;
          pulsewidth_d=Ts-2*underlap; 
       end
        if pulsewidth_d<=2*underlap;
          pulsewidth_d=2*underlap; 
        end
        
        if pulsewidth_e>=Ts-2*underlap;
          pulsewidth_e=Ts-2*underlap; 
       end
        if pulsewidth_e<=2*underlap;
          pulsewidth_e=2*underlap; 
        end
        
       
    
    SectorNum=mod(SectorNum, 10);
    i=0;   
    while (i<floor(SectorNum/2))
       temp=pulsewidth_e;
       pulsewidth_e=pulsewidth_d;
       pulsewidth_d=pulsewidth_c;
       pulsewidth_c=pulsewidth_b;
       pulsewidth_b=pulsewidth_a;
       pulsewidth_a=temp;
       
       TempState=SwitchState_e;
       SwitchState_e=SwitchState_d;
       SwitchState_d=SwitchState_c;
       SwitchState_c=SwitchState_b;
       SwitchState_b=SwitchState_a;
       SwitchState_a=TempState;
       
       i=i+1;
    end
    % ----------------add dead-time effect---------------------------------
    
%    if (Ia<0)  pulsewidth_a=pulsewidth_a+2*DeadBand;  end
%    if (Ib<0)  pulsewidth_b=pulsewidth_b+2*DeadBand;  end
%    if (Ic<0)  pulsewidth_c=pulsewidth_c+2*DeadBand;  end
%    if (Id<0)  pulsewidth_d=pulsewidth_d+2*DeadBand;  end
%    if (Ie<0)  pulsewidth_e=pulsewidth_e+2*DeadBand;  end
 
    
sys = [ StatorFlux_ds;StatorFlux_qs;FluxErrSt;TorqueErrSt; SpeedErrSt;SpeedCalCnt;TorqueRef;VoltageErrStat;DutyRatio;RotorFluxMag;
    RFluxSlipAng;RotorFluxAng; StatorFluxAng;Torque1;
    pulsewidth_a;pulsewidth_b;pulsewidth_c;pulsewidth_d;pulsewidth_e;
    SwitchState_a;SwitchState_b;SwitchState_c;SwitchState_d;SwitchState_e;Region;VectorLength];

% end mdlUpdate

%
%=============================================================================
% mdlOutputs
% Return the block outputs.
%=============================================================================
%
function sys=mdlOutputs(t,x,u)

%-----------------------------newly add by liliang Gao 24/05/2006
    Ts=200e-6;
    t_record=t;
    TorqueRef=x(7);
    DutyRatio=x(9);
    RotorFluxMag=x(10);
    Torque1=x(14);
    pulsewidth_a=x(15);
    pulsewidth_b=x(16);
    pulsewidth_c=x(17);
    pulsewidth_d=x(18);
    pulsewidth_e=x(19);
    SwitchState_a=x(20);
    SwitchState_b=x(21);
    SwitchState_c=x(22);
    SwitchState_d=x(23);
    SwitchState_e=x(24);
    Region=x(25);
    VectorLength=x(26);
    
  
    

    
    ta1=(Ts-pulsewidth_a)/2+t_record; 
    ta2=(Ts+pulsewidth_a)/2+t_record;
    tb1=(Ts-pulsewidth_b)/2+t_record;
    tb2=(Ts+pulsewidth_b)/2+t_record;
    tc1=(Ts-pulsewidth_c)/2+t_record;
    tc2=(Ts+pulsewidth_c)/2+t_record;
    td1=(Ts-pulsewidth_d)/2+t_record;
    td2=(Ts+pulsewidth_d)/2+t_record;
    te1=(Ts-pulsewidth_e)/2+t_record;
    te2=(Ts+pulsewidth_e)/2+t_record;

%--------------------------------------------------------------------
% Tr=Rr/Lr;
%if x(1)==0 RotorFluxMag=1e-6;else RotorFluxMag=x(1);end
    %Wsl=Lm/RotorFluxMag*Tr*Iqse;

    
sys=[ta1;ta2;tb1;tb2;tc1;tc2;td1;td2;te1;te2;SwitchState_a;SwitchState_b;SwitchState_c;SwitchState_d;SwitchState_e;Region;TorqueRef;Torque1;RotorFluxMag;DutyRatio;VectorLength];


%=============================================================================
% mdlGetTimeOfNextVarHit
% Return the time of the next hit for this block.  Note that the result is
% absolute time.  Note that this function is only used when you specify a
% variable discrete-time sample time [-2 0] in the sample time array in
% mdlInitializeSizes.
%=============================================================================
%
function sys=mdlGetTimeOfNextVarHit(t,x,u)
sys =[];

% end mdlGetTimeOfNextVarHit

%
%=============================================================================
% mdlTerminate
% Perform any end of simulation tasks.
%=============================================================================
%
function sys=mdlTerminate(t,x,u)

sys = [];

% end mdlTerminate
